#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//70s PetalsMod01.fsh   by  JennySchub   
//https://www.shadertoy.com/view/7tBSRV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.141592653 
#define countX 17.
#define petalWidth .4
#define AA 2.

vec3 colMap(float v) {

	v=mod(v, PI+1.3)-.8;	
    return vec3(
		sin(sin(v-.6)),
		sin(sin(v)),
		sin(sin(v+.8))
	);

} 

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    fragColor= vec4(0.);
    for(float aa=0.; aa<AA; aa++){
        for(float bb=0.; bb<AA; bb++){

            vec2 uv = (fragCoord + vec2(aa,bb)*1./AA)/iResolution.xy;


            uv-=.5;
            uv.y*=iResolution.y/iResolution.x;
            uv*=2.;

            float tim=-iTime*.1;
            float posintim=sin(tim)*.5+.5;
            float dst=length(uv);
            vec2 tuv = vec2(0.,dst);
            vec2 id = vec2(0.);
            float zoomSpeed=tim*.4;
            float angle1=(atan(uv.x,uv.y)/PI*.5+.5)+zoomSpeed + tim*.3;
            float angle2=angle1-2.*zoomSpeed;
            float add=pow(dst, posintim*.7+.1)*countX*petalWidth;
            tuv.x=mod(angle1*countX+add, 1.);
            tuv.y=mod(angle2*countX-add, 1.);
            id.x=ceil(angle1*countX+add);
            id.y=floor(angle2*countX-add);
            float edgeDist = max(max(tuv.x, tuv.y), max(1.-tuv.x, 1.-tuv.y));
            tuv-=.5;
            tuv*=dst*3.;
            float t=log(dst+1.6);
            float v=abs(tuv.x+tuv.y)+pow(tuv.y-tuv.x, 2.);
            v+=posintim *pow(edgeDist,25.);
            vec3 col=vec3(smoothstep(t+.1,t,v) );
            col*=colMap(abs(id.x-id.y)*.4);


            fragColor += vec4(col/(AA*AA),1.0);
        }
    }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

